<?php

require_once 'config.php';

class Database
{
    
    private $host;
    private $db_name;
    private $username;
    private $password;
    public $conn;
    
    public function __construct() {
        global $db_host, $db_name, $db_user, $db_pass;
        
        $this->host = $db_host;
        $this->db_name = $db_name;
        $this->username = $db_user;
        $this->password = $db_pass;
        
    }
     
    public function dbConnection()
	{
     
	    $this->conn = null;    
        try
		{
            $this->conn = new PDO("mysql:host=" . $this->host . ";dbname=" . $this->db_name, $this->username, $this->password);
			$this->conn->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);	
        }
		catch(PDOException $exception)
		{
            echo "Connection error: " . $exception->getMessage();
        }
         
        return $this->conn;
    }
}

$connection = mysqli_connect($db_host, $db_user, $db_pass);
if (!$connection){
    die("Database Connection Failed" . mysqli_error($connection));
}
$select_db = mysqli_select_db($connection, $db_name);
if (!$select_db){
    die("Database Selection Failed" . mysqli_error($connection));
}

?>